'' ------------------------------------------------------------------------ ''
''  @@ Source Documentation                     *** BASIC Version ***       ''
''                                                                          ''
''  Title : DEMOCD.BAS                                                      ''
''                                                                          ''
''  Description :                                                           ''
''      Exercises all the features enhanced in the Creative CDROM drive.    ''
''                                                                          ''
''  Note :                                                                  ''
''      Use switch /Fs for Microsoft Basic PDS 7.1  compiler.               ''
''      Some of the features in this program e.g LOCK, UNLOCK, EJECT        ''
''      and CLOSE are not applicable to the earlier version of Creative     ''
''      CDROM drives.                                                       ''
''                                                                          ''
''  Copyright (c) Creative Technology Ltd, 1993. All rights reserved.       ''
''                                                                          ''
'' ------------------------------------------------------------------------ ''

' $INCLUDE: 'SBKCD.BI'

DECLARE SUB ShowInfo()
DECLARE SUB Display()
DECLARE FUNCTION HSG2RED&(wdata AS LONG)
DECLARE FUNCTION BCD2Binary% (wdata AS INTEGER)


DIM skipSec AS INTEGER
DIM wKey AS INTEGER, quit AS INTEGER
DIM drvNum AS INTEGER


    skipSec = 16
    quit = 0

    IF sbcdInit%(drvNum) = 0 THEN  '* initialization *'

        CALL Display  '* display drive operation options *'

        WHILE quit = 0

            CALL ShowInfo  '* show CD info *'

            c$ = INKEY$

            IF c$ <> "" THEN

                c$ = LEFT$(UCASE$(c$), 1)

                SELECT CASE c$

                    CASE "P"                        '* play first track *'
                        t% = sbcdPlay%(1,0,&Hffff)  '* till the end *'

                    CASE "S"                        '* stop *'
                        t% = sbcdStop%

                    CASE "A"                        '* pause *'
                        t% = sbcdPause%

                    CASE "C"                        '* continue *'
                        t% = sbcdContinue%

                    CASE "N" :                      '* next track *'
                        t% = sbcdNextTrack%

                    CASE "L" :                      '* previous track *'
                        t% = sbcdPrevTrack%

                    CASE "F" :                      '* fast forward 16 sec *'
                        t% = sbcdFastforward%(skipSec)

                    CASE "R" :                      '* rewind 16 sec *'
                        t% = sbcdRewind%(skipSec)

                    CASE "E" :
                        t% = sbcdEject%             '* open tray *'

                    CASE "D" :
                        t% = sbcdCloseTray%         '* close tray *'

                    CASE "X" :
                        t% = sbcdLockDoor%(1)       '* lock tray *'

                    CASE "Z" :
                        t% = sbcdLockDoor%(0)       '* unlock tray *'

                    CASE "Q" :                      '* quit *'
                        quit = 1
                        PRINT ""

                END SELECT
            END IF
        WEND
    ELSE
        PRINT "Initialization error."
    END IF
END


'* ------------------------------------------------------------------------ *'
'*  Conversion from BCD to binary                                           *'
'* ------------------------------------------------------------------------ *'
FUNCTION BCD2Binary% (wdata AS INTEGER)

    DIM retVal AS INTEGER


    wdata = wdata AND &H00ff
    retVal = (wdata \ 16) * 10 + (wdata and &H0f)

    BCD2Binary% = retVal

END FUNCTION


'* ------------------------------------------------------------------------ *'
'*  Conversion from High Sierra format to Red Book format                   *'
'* ------------------------------------------------------------------------ *'
FUNCTION HSG2RED&(wdata AS LONG)

    DIM v0 AS LONG, v1 AS LONG, v2 AS LONG


    v2 = wdata / 4500               '* 4500 = 60 * 75 *'
    v1 = (wdata MOD 4500) / 75
    v0 = (wdata MOD 4500) MOD 75

    HSG2RED& = ((v2 * &H10000) OR (v1 * &H100) OR v0)

END FUNCTION


'* ------------------------------------------------------------------------ *'
'*  Display drive operation options                                         *'
'* ------------------------------------------------------------------------ *'
SUB Display

    PRINT ""
    PRINT "Compact Disc Player Demo Program"
    PRINT ""
    PRINT "     P : Play"
    PRINT "     S : Stop"
    PRINT "     A : Pause"
    PRINT "     C : Continue"
    PRINT "     N : Next Track"
    PRINT "     L : Previous Track"
    PRINT "     F : Fast Forward"
    PRINT "     R : Rewind"
    PRINT "     E : Eject"
    PRINT "     D : Close"
    PRINT "     X : Lock"
    PRINT "     Z : Unlock"
    PRINT "     Q : Quit"
    PRINT ""

END SUB


'* ------------------------------------------------------------------------ *'
'*  Show CD info                                                            *'
'* ------------------------------------------------------------------------ *'
SUB ShowInfo

    DIM qchInfo AS QCHANxINFO
    DIM volume AS LONG
    DIM t AS INTEGER


    t = sbcdGetLocInfo%(qchInfo)
    t = sbcdGetVolume%(volume)
    volume = HSG2RED&(volume)

    PRINT USING "Disc -###:##    Track -## ##:##    Vol -###:##";_
                ASC(qchInfo.bPMin);ASC(qchInfo.bPSec);_
                BCD2Binary(INT(ASC(qchInfo.bTno)));_
                ASC(qchInfo.bMin);ASC(qchInfo.bSec);_
                INT(ABS(volume \ &H10000&)) AND &Hff;_
                INT(ABS(volume AND &Hffff&)) \ &H100;
    LOCATE ,1

END SUB
'* End of file *'
