/* ------------------------------------------------------------------------ */
/*  @@ Source Documentation                         *** C Version ***       */
/*                                                                          */
/*  Title : DEMOCD.C                                                        */
/*                                                                          */
/*  Description :                                                           */
/*      Exercises all the features enhanced in the Creative CDROM drive.    */
/*                                                                          */
/*  Note :                                                                  */
/*      Some of the features in this program e.g LOCK, UNLOCK, EJECT        */
/*      and CLOSE are not applicable to the earlier version of Creative     */
/*      CDROM drives.                                                       */
/*                                                                          */
/*  Copyright (c) Creative Technology Ltd, 1993. All rights reserved.	    */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <bios.h>
#include <conio.h>

#include "sbkmacro.h"
#include "sbkcd.h"

/* Local functions */
unsigned char BCD2Binary( unsigned char ) ;
unsigned long HSG2RED( unsigned long ) ;
void Display( void ) ;
void ShowInfo( void ) ;


main()
{
    WORD    skip_sec = 16 ;
    WORD    wKey, quit=0 ;
    int     drv_num ;


    if( !sbcdInit( &drv_num ) )     /* initialization */
    {
        Display() ;                 /* display drive operation options */

        while( quit == 0 )
        {
            ShowInfo() ;            /* show CD info */

            if (sbkBiosKeybrd(KEYBRD_READY))
            {
                wKey = sbkBiosKeybrd(KEYBRD_READ) & 0xff ;
                wKey = toupper((int)wKey) ;

                switch(wKey)
                {
                    case 'P' :                      /* play first track */
                        sbcdPlay( 1, 0, 0xffff ) ;  /* till the end */
                        break ;

                    case 'S' :                      /* stop */
                        sbcdStop() ;
                        break ;

                    case 'A' :                      /* pause */
                        sbcdPause() ;
                        break ;

                    case 'C' :                      /* continue */
                        sbcdContinue() ;
                        break ;

                    case 'N' :                      /* next track */
                        sbcdNextTrack() ;
                        break ;

                    case 'L' :                      /* previous track */
                        sbcdPrevTrack() ;
                        break ;

                    case 'F' :                      /* fast forward 16 sec */
                        sbcdFastForward( skip_sec ) ;
                        break ;

                    case 'R' :                      /* rewind 16 sec */
                        sbcdRewind( skip_sec ) ;
                        break ;

                    case 'E' :
                        sbcdEject();                /* open tray */
                        break;

                    case 'D' :
                        sbcdCloseTray();            /* close tray */
                        break;

                    case 'X' :
                        sbcdLockDoor(1);            /* lock tray */
                        break;

                    case 'Z' :
                        sbcdLockDoor(0);            /* unlock tray */
                        break;

                    case 'Q' :                      /* quit */
                        quit = 1 ;
                }
            }
        }
    }
    else
        printf( "Initialization error" ) ;

    return 0 ;
}


/**
 ** Display drive operation options
 **/
void Display( void )
{
    printf( "\r\n\r\n\r\nCompact Disc Player Demo Program\r\n\r\n" ) ;
    printf( "    P  : Play\n\r" ) ;
    printf( "    S  : Stop\n\r" ) ;
    printf( "    A  : Pause\n\r" ) ;
    printf( "    C  : Continue\n\r" ) ;
    printf( "    N  : Next Track\n\r" ) ;
    printf( "    L  : Previous Track\n\r" ) ;
    printf( "    F  : Fast Forward\n\r" ) ;
    printf( "    R  : Rewind\n\r" ) ;
    printf( "    E  : Eject\n\r" ) ;
    printf( "    D  : Close\n\r" ) ;
    printf( "    X  : Lock\n\r" ) ;
    printf( "    Z  : Unlock\n\r" ) ;
    printf( "    Q  : Quit\n\r\n\r" ) ;
}


/**
 ** Show CD info
 **/
void ShowInfo(void)
{
    QCHAN_INFO      qch_info ;
    unsigned long   volume ;


    sbcdGetLocInfo( &qch_info ) ;
    sbcdGetVolume( &volume ) ;
    volume = HSG2RED( volume ) ;

    printf("Disc - %02d:%02d    Track - %02d %02d:%02d    Vol - %02d:%02d    \r",
            qch_info.bPMin, qch_info.bPSec,
            BCD2Binary(qch_info.bTNo),
            qch_info.bMin,  qch_info.bSec,
            LOBYTE(HIWORD(volume)), HIBYTE(LOWORD(volume)) ) ;
}


/**
 ** Conversion from BCD to binary
 **/
unsigned char BCD2Binary( unsigned char data )
{
    unsigned char   ret_val ;


    ret_val = ( data >> 4 )*10 + ( data & 0xf ) ;

    return( ret_val ) ;
}


/**
 ** Conversion from High Sierra format to Red Book format
 **/
unsigned long HSG2RED( unsigned long data )
{
    unsigned long   v0, v1, v2 ;


    v2 = data / 4500 ;              /* 4500 = 60 * 75 */
    v1 = ( data % 4500 ) / 75 ;
    v0 = ( data % 4500 ) % 75 ;

    return( ( v2 << 16 ) | ( v1 << 8 ) | v0 ) ;
}
/* End of file */
