## ------------------------------------------------------------------------ ##
##  @@ Source Documentation     *** Turbo C and Borland C version ***       ##
##                                                                          ##
##  Title : DEMOCD.MAK                                                      ##
##                                                                          ##
##  Description :                                                           ##
##      Make file for DEMOCD.C                                              ##
##                                                                          ##
##  Compile :                                                               ##
##      Borland C++ :- MAKE -DBCC -f DEMOCD.MAK                             ##
##      Turbo C/C++ :- MAKE -fDEMOCD.MAK                                    ##
##                                                                          ##
##      Include switch -DMODEl=c (compact model) to change memory model,    ##
##      and switch -DDEBUG to compile with debug info before -f.            ##
##                                                                          ##
##  Copyright (c) Creative Technology Ltd, 1993. All rights reserved.       ##
##                                                                          ##
## ------------------------------------------------------------------------ ##

# default memory model is small
!if !$d(MODEL)
MODEL=s
!endif

!if '$(MODEL)' == 'h'
LIBMODEL = l
!else
LIBMODEL = $(MODEL)
!endif

!if $d(BCC)
COMPILER = bcc
!else
COMPILER = tcc
!endif

!if !$d(DEBUG)
CFLAG = -m$(MODEL)
!else
CFLAG = -m$(MODEL) -v -y -M
!endif

CC = $(COMPILER) $(CFLAG)

TARGET = democd

#               *Implicit Rules*
.c.obj:
  $(COMPILER) -c $(CFLAG) $<
.cpp.obj:
  $(COMPILER) -c $(CFLAG) $<

#               *Explicit Rules*
$(TARGET).exe: $(TARGET).obj
  $(CC) $(TARGET).obj sbklib$(LIBMODEL).lib

#               *Individual File Dependencies*
$(TARGET).obj: democd.c
