## ------------------------------------------------------------------------ ##
##  @@ Source Documentation     ***  Turbo C and Borland C version ***      ##
##                                                                          ##
##  Title : MIDIIN.MAK                                                      ##
##                                                                          ##
##  Description :                                                           ##
##      Make file for MIDIIN.C                                              ##
##                                                                          ##
##  Compile :                                                               ##
##      Borland C++ :- MAKE -DBCC -f MIDIIN.MAK                             ##
##      Turbo C/C++ :- MAKE -fMIDIIN.MAK                                    ##
##                                                                          ##
##      Include switch -DMODEl=c (compact model) to change memory model,    ##
##      and switch -DDEBUG to compile with debug info before -f.            ##
##                                                                          ##
##  Copyright (c) Creative Technology Ltd, 1993. All rights reserved.       ##
##                                                                          ##
## ------------------------------------------------------------------------ ##

# default memory model is small
!if !$d(MODEL)
MODEL=s
!endif

!if '$(MODEL)' == 'h'
LIBMODEL = l
!else
LIBMODEL = $(MODEL)
!endif

!if $d(BCC)
COMPILER = bcc
!else
COMPILER = tcc
!endif

!if !$d(DEBUG)
CFLAG = -m$(MODEL) -N- -B
!else
CFLAG = -m$(MODEL) -v -y -M -N- -B
!endif

CC = $(COMPILER) $(CFLAG)

TARGET = midiin

#               *Implicit Rules*
.c.obj:
  $(COMPILER) -c $(CFLAG) $<
.cpp.obj:
  $(COMPILER) -c $(CFLAG) $<

#               *Explicit Rules*
$(TARGET).exe: $(TARGET).obj
  $(CC) $(TARGET).obj sbklib$(LIBMODEL).lib csbkx.lib

#               *Individual File Dependencies*
$(TARGET).obj: midiin.c
