/* ------------------------------------------------------------------------ */
/*  @@ Source Documentation                         *** C Version ***       */
/*                                                                          */
/*  TITLE : MIDIOUT.C                                                       */
/*                                                                          */
/*  DESCRIPTION :                                                           */
/*      This program demostrates how to use the CTMIDI.DRV driver           */
/*      to output MIDI codes to internal or external MIDI synthesizer.      */
/*                                                                          */
/*      Note that the BLASTER environment has to be set before executing    */
/*      this program.                                                       */
/*                                                                          */
/*  Copyright (c) Creative Technology Ltd, 1993. All rights reserved.       */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#include  <io.h>
#include  <dos.h>
#include  <bios.h>
#include  <fcntl.h>
#include  <stdlib.h>
#include  <io.h>
#include  <conio.h>
#include  <dos.h>

#include  "sbkmidi.h"
#include  "sbkmacro.h"
#include  "sbkx.h"
#include  "Loaddrv.c"

/* Local functions */
int PrepareCTMIDIDrv(char * BlasterEnv) ;

/* Global variable */
char far * lpOrigin ;       /* original driver buffer */

/* C major scale */
BYTE szNote[] = {60,62,64,65,67,69,71,72,71,69,67,65,64,62,60,0} ;

main ()
{
    char * EnvStr ;
    int x, y, count = 0 ;


    printf("\nOutput MIDI codes to internal or external MIDI synthesizer.") ;

    if ((EnvStr = getenv("BLASTER")) == NULL)
    {
        printf("\nBLASTER environment not set.");
        exit(1);
    }

    /* Load CTMIDI.DRV into memory */
    if (!PrepareCTMIDIDrv(EnvStr))
    {
        /* Initialize CTMIDI.DRV driver */
        if (!ctmdInit())
        {
            printf("\nWait...Output MIDI codes...Press a key to stop.") ;

            while ((szNote[count] != 0) && (!sbkBiosKeybrd(KEYBRD_READY)))
            {
                /* send status note on, note and velocity */
                ctmdSendShortMessage(0x90,(WORD)szNote[count],0x60) ;

                for (x=0; x<100; x++)
                    for (y=0; y<8000; y++) ;

                /* send status note off, note and velocity */
                ctmdSendShortMessage(0x80,(WORD)szNote[count],0x60) ;

                count ++ ;

            }
            /* Terminate CTMIDI.DRV driver */
            ctmdTerminate() ;
        }
        else
            printf("\nError CTMIDI driver initialization.") ;
    }
    return 0 ;
}


/* ------------------------------------------------------------------------ */
/*  @@ Usage                                                                */
/*                                                                          */
/*  PrepareCTMIDIDrv(char * BlasterEnv)                                     */
/*                                                                          */
/*  Description :                                                           */
/*      Load and endorses CTMIDI.DRV.                                       */
/*                                                                          */
/*  Entry :                                                                 */
/*      BlasterEnv - pointer to the BLASTER enviroment setting.             */
/*                                                                          */
/*  Exit :                                                                  */
/*      zero if sucessful, non-zero otherwise.                              */
/*                                                                          */
/* ------------------------------------------------------------------------ */

int PrepareCTMIDIDrv(char * BlasterEnv)
{
    char * EnvStr ;


    /* load CTMIDI.DRV driver into memory. */
    if ((CTmidiDrv = (char far *)sbkLoadDriver("CTMIDI.DRV",UNUSED,(char far **)&lpOrigin)) != NULL)
    {
        if (ctmdGetDrvVer() >= 0x0100)
        {
            /* Get MIDI environment setting */
            if ((EnvStr = getenv("MIDI")) != NULL)
                ctmdGetMidiEnvSettings((const char far *)EnvStr) ;

            if (!ctmdGetEnvSettings((char far *)BlasterEnv))
                return(0) ;
            else
                printf("\nBLASTER environment is not valid") ;
        }
        else
        {
            printf("\nInvalid CTMIDI.DRV - ") ;
            printf("I need CTMIDI.DRV version 1.00 or higher.\n") ;
        }
    }
    return(1) ;
}
/* End of file */
