;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; ADDXADJ.ASM :- Normalizes segment and offset functions.
;
;   Author  : CWLim
;
;   Helper function for QuickBasic 4.5, Basic PDS 7.1 and
;   Visual Basic for DOS version 1.0.
;
;   You need to use MASM 6 to assemble the program.
;
;   Copyright (c) Creative Technology Ltd, 1993, All rights reserved
;
;
;   Important Note:
;       This source code is only intended as a supplement to the
;       existing Basic functions to facilitate the use of SBK
;       library.
;
;       You can use and modify these functions in any way you find
;       useful, provided that you agree that Creative Technology Ltd
;       has no warranty obligations or liability for any functions
;       which are modified.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

      .MODEL large, BASIC

      .DATA

      .CODE   CT_TEXT


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   Normalizes segment address.
;
;   FUNCTION sbkNormalizeSegment% (BYVAL wSegment%, BYVAL wOffset%)
;
;   Entry :
;       wSegment% :- segment address
;       wOffset%  :- offset address
;
;   Exit  :
;       Normalized segment address.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
sbkNormalizeSegment  PROC                wSegment : WORD,
                                         wOffset  : WORD
        MOV    AX,wSegment
        MOV    DX,wOffset
        SHR    DX,1
        SHR    DX,1
        SHR    DX,1
        SHR    DX,1
        ADD    AX,DX
        RET
sbkNormalizeSegment  ENDP


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;   Normalizes offset address.
;
;   FUNCTION sbkNormalizeOffset% (BYVAL wOffset%)
;
;   Entry :
;       wOffset%  :- offset address
;
;   Exit  :
;       Normalized offset address.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
sbkNormalizeOffset  PROC                wOffset : WORD

        MOV    AX,wOffset
        AND    AX,0FH
        RET
sbkNormalizeOffset  ENDP

	    END
