;; ------------------------------------------------------------------------ ;;
;;  @@ Source Documentation               *** MASM 6.0 Version ***          ;;
;;                                                                          ;;
;;  Title   :        CTMMSYS.ASM                                            ;;
;;                                                                          ;;
;;  Description :                                                           ;;
;;      CTMMSYS.SYS driver functions calling interface for MSC 6.0,         ;;
;;      PASCAL 6.0 and PASCAL 7.0, and QuickBASIC 4.5, Basic PDS 7.1        ;;
;;      and Visual Basic for DOS 1.0.                                       ;;
;;                                                                          ;;
;;  Here are two and only two functions :                                   ;;
;;      ctmmInit                                                            ;;
;;      ctmmCall                                                            ;;
;;                                                                          ;;
;;  Copyright (c) Creative Technology Ltd, 1993.  All rights reserved.      ;;
;;                                                                          ;;
;;  Important Note:                                                         ;;
;;      none.                                                               ;;
;;                                                                          ;;
;;  Build date :                                                            ;;
;;      15-06-93                                                            ;;
;;                                                                          ;;
;;  By :                                                                    ;;
;;      LOHSH                                                               ;;
;;                                                                          ;;
;; ------------------------------------------------------------------------ ;;

    .MODEL  large, C

    .DATA
    DRV_HANDLE          dw          -1
    CTMM_DRIVER         db          'CTMMSYS$',0
    CTMM_EXIST          dw          0           ; flag 1 indicates CTMMSYS driver installed
    CTMM_ENTRYPOINT_KEY dd          4D6D7443H   ; far pointer to the CTMMSYS.SYS driver
                                                ; need to be initialized to 'CtmM'

    .CODE   CT_TEXT                 ;;CodeSegmentName


;; ------------------------------------------------------------------------ ;;
;;  @@ Usage                                                                ;;
;;                                                                          ;;
;;  int ctmmInit (void)                                                     ;;
;;                                                                          ;;
;;  Description :                                                           ;;
;;      Set up entry point to the CTMMSYS.SYS driver.                       ;;
;;                                                                          ;;
;;  Entry :                                                                 ;;
;;      none.                                                               ;;
;;                                                                          ;;
;;  EXit :                                                                  ;;
;;      return 0 if successful else return 1.                               ;;
;;                                                                          ;;
;; ------------------------------------------------------------------------ ;;

ctmmInit       PROC    <LOADDS>

    push    bx
    push    cx

    ; open CTMMSYS.SYS
    mov     ax, 3D00H
    mov     dx, offset CTMM_DRIVER
    int     21H

    ; carry flag set if error
    jnc     OUI2
    mov     ax, 1
    jmp     short FINIS2

OUI2:
    mov     DRV_HANDLE, ax
    mov     bx, ax
    mov     ax, 4402H
    mov     cx, 4
    mov     dx, OFFSET CTMM_ENTRYPOINT_KEY
    int     21h
    jc      FINIS1
    mov     CTMM_EXIST, 1

FINIS1:
    ; close CTMMSYS.SYS
    mov     ax, 3E00H
    mov     bx, DRV_HANDLE
    int     21H

    mov     ax, 0
    cmp     CTMM_EXIST, 1
    je      FINIS2
    mov     ax, 1

FINIS2:
    pop     cx
    pop     bx
    ret

ctmmInit    ENDP


;; ------------------------------------------------------------------------ ;;
;;  @@ Usage                                                                ;;
;;                                                                          ;;
;;  DWORD ctmmCall (DWORD hDev, WORD mmDevice, WORD wMsg,                   ;;
;;                  DWORD dwParam1, DWORD dwParam2)                         ;;
;;                                                                          ;;
;;  Description :                                                           ;;
;;      Invoke CTMMSYS driver function specified in the wMsg field.         ;;
;;                                                                          ;;
;;  Entry :                                                                 ;;
;;      hDev      :- handle of open device.                                 ;;
;;      mmDevice  :- type of device.                                        ;;
;;      wMsg      :- Message being sent to the driver.                      ;;
;;      dwParam1  :- Message-dependent parameter.                           ;;
;;      dwParam2  :- Message-dependent parameter.                           ;;
;;                                                                          ;;
;;  Exit :                                                                  ;;
;;      return 0 if successful else return error code.                      ;;
;;                                                                          ;;
;; ------------------------------------------------------------------------ ;;

ctmmCall       PROC      <LOADDS>       hDev : dword,
                                    mmDevice : word,
                                        wMsg : word,
                                    dwParam1 : dword,
                                    dwParam2 : dword

    test    CTMM_EXIST, 1
    jnz     OUI2
    mov     ax, 1
    mov     dx, 0
    jmp     short FINIS2

OUI2:
    push    word ptr [hDev + 2]
    push    word ptr [hDev]
    push    word ptr [mmDevice]
    push    word ptr [wMsg]
    push    word ptr [dwParam1 + 2]
    push    word ptr [dwParam1]
    push    word ptr [dwParam2 + 2]
    push    word ptr [dwParam2]

    call    dword ptr ds:[CTMM_ENTRYPOINT_KEY]

FINIS2:
    ret

ctmmCall    ENDP

    END      ;; End of code
