'*==========================================================================*'
'*  SBKCD.BI (revision 1.0)                                                 *'
'*        API for SBCD.SYS                                                  *'
'*                                                                          *'
'*--------------------------------------------------------------------------*'
'*  Copyright (c) Creative Technology Ltd, 1991-1993.                       *'
'*  All Rights Reserved.                                                    *'
'*==========================================================================*'


'
' Typedef for records
'
TYPE DISCxINFO
    bLoTNo          AS STRING*1     ' Lowest track number
    bHiTNo          AS STRING*1     ' Highest track number
    dwLeadOut       AS LONG         ' Lead-out address
END TYPE

TYPE QCHANxINFO
    bTNo            AS STRING*1     ' Current track number in BCD format
    bReserved0      AS STRING*1     '
    bMin            AS STRING*1     ' Minute  '
    bSec            AS STRING*1     ' Second  ' running time within a track
    bFrame          AS STRING*1     ' Frame   '
    bReserved1      AS STRING*1     '
    bPMin           AS STRING*1     ' Minute  '
    bPSec           AS STRING*1     ' Second  ' running time on the disc
    bPFrame         AS STRING*1     ' Frame   '
END TYPE


'
'Constants
'
CONST NOTxCDROMxDRIVE    =  &H22   ' Not a CD-ROM drive
CONST NOTxPLAYxMODE      =  &H23   ' CD-ROM drive not in play mode
CONST NOTxPAUSExMODE     =  &H24   ' CD-ROM drive not in pause mode
CONST MAXxTRACKxNO       =  100    ' Max. no. of tracks on a disc


'
'Function prototypes
'
DECLARE FUNCTION sbcdCloseTray% CDECL ()
DECLARE FUNCTION sbcdContinue% CDECL ()
DECLARE FUNCTION sbcdEject% CDECL ()
DECLARE FUNCTION sbcdFastForward% CDECL (BYVAL wSec%)
DECLARE FUNCTION sbcdGetAudioStatus% CDECL (SEG wStatus%)
DECLARE FUNCTION sbcdGetDeviceStatus% CDECL (SEG dwStatus& )
DECLARE FUNCTION sbcdGetDiscInfo% CDECL (SEG lpBuffer AS DISCxINFO)
DECLARE FUNCTION sbcdGetLocInfo% CDECL (SEG lpBuffer AS QCHANxINFO)
DECLARE FUNCTION sbcdGetVolume% CDECL (SEG lpdwVolumeSize&)
DECLARE FUNCTION sbcdInit% CDECL (SEG lpNumDrive%)
DECLARE FUNCTION sbcdLockDoor% CDECL (BYVAL bFunction%)
DECLARE FUNCTION sbcdMediaChanged% (SEG lpChanged%)
DECLARE FUNCTION sbcdNextTrack% CDECL ()
DECLARE FUNCTION sbcdPause% CDECL ()
DECLARE FUNCTION sbcdPlay% CDECL (BYVAL bTrackNo%, BYVAL wOffset%, BYVAL wDuration%)
DECLARE FUNCTION sbcdPrevTrack% CDECL ()
DECLARE FUNCTION sbcdReadToc% CDECL (BYVAL lpTOCBuffer&)
DECLARE FUNCTION sbcdRewind% CDECL (BYVAL wSec%)
DECLARE FUNCTION sbcdSelectDrive% CDECL (BYVAL bDriveNum%)
DECLARE FUNCTION sbcdStop% CDECL ()
'* End of file *'
