/*==========================================================================*\
 | SBKCD.H (revision 1.0)                                                   |
 |       API for SBCD.SYS                                                   |
 |                                                                          |
 |--------------------------------------------------------------------------|
 | Copyright (c) Creative Technology Ltd, 1991-1993.                        |
 | All Rights Reserved.                                                     |
\*==========================================================================*/

#ifndef _SBKCD_H
    #define _SBKCD_H

#include "ctstddef.h"

#ifdef __cplusplus
extern "C" {
#endif


#ifndef TRUE
    #define TRUE    1
#endif

#ifndef FALSE
    #define FALSE   0
#endif

/* Many functions return 0 if nothing went wrong. */
#ifndef NO_ERROR
     #define NO_ERROR   0
#endif

#pragma pack(1)

#ifndef DISC_INFO_TYPEDEFED
     #define DISC_INFO_TYPEDEFED
     typedef struct DISC_INFO
     {
          BYTE        bLoTNo ;    /* lowest track */
          BYTE        bHiTNo ;    /* highest track */
          DWORD       dwLeadOut ; /* lead-out track address in Red Book format */
     } DISC_INFO ;
#endif

#ifndef QCHAN_INFO_TYPEDEFED
#define QCHAN_INFO_TYPEDEFED
typedef struct QCHAN_INFO
     {
          BYTE        bTNo ;       /* Current track number in BCD format */
          BYTE        bReserved0 ;
          BYTE        bMin ;       /* minute '                             */
          BYTE        bSec ;       /* second ' running time within a track */
          BYTE        bFrame ;     /* frame  '                             */
          BYTE        bReserved1 ;
          BYTE        bPMin ;      /* minute '                             */
          BYTE        bPSec ;      /* second ' running time on the disk    */
          BYTE        bPFrame ;    /* frame  '                             */
     } QCHAN_INFO ;
#endif

#pragma pack()


/*--------------------------------------------------------------------------*\
 | Function prototypes for SBCD.SYS driver                                  |
\*--------------------------------------------------------------------------*/

int CDECL sbcdCloseTray( void ) ;
int CDECL sbcdContinue( void ) ;
int CDECL sbcdEject( void ) ;
int CDECL sbcdFastForward( WORD wSec ) ;
int CDECL sbcdGetAudioStatus( int FAR *lpStatus ) ;
int CDECL sbcdGetDeviceStatus( DWORD FAR *lpStatus ) ;
int CDECL sbcdGetDiscInfo( DISC_INFO FAR *lpBuffer ) ;
int CDECL sbcdGetLocInfo( QCHAN_INFO FAR *lpBuffer ) ;
int CDECL sbcdGetVolume( DWORD FAR *lpdwVolSize ) ;
int CDECL sbcdInit( int FAR *lpNumDrive ) ;
int CDECL sbcdLockDoor( BYTE bFunction ) ;
int CDECL sbcdMediaChanged( int FAR *lpChanged ) ;
int CDECL sbcdNextTrack( void ) ;
int CDECL sbcdPause( void ) ;
int CDECL sbcdPlay( BYTE bTrackNo, WORD wOffset, WORD wDuration ) ;
int CDECL sbcdPrevTrack( void ) ;
int CDECL sbcdReadTOC( DWORD FAR * lpTOCBuffer ) ;
int CDECL sbcdRewind( WORD wSec ) ;
int CDECL sbcdSelectDrive( BYTE bDriveNum ) ;
int CDECL sbcdStop( void ) ;


/*--------------------------------------------------------------------------*\
 |  Error code returned by functions                                        |
\*--------------------------------------------------------------------------*/

#ifndef NOT_CDROM_DRIVE
    #define NOT_CDROM_DRIVE    0x22    /* Not a CD-ROM drive */
#endif

#ifndef NOT_PLAY_MODE
    #define NOT_PLAY_MODE      0x23    /* CD-ROM drive not in play mode */
#endif

#ifndef NOT_PAUSE_MODE
    #define NOT_PAUSE_MODE     0x24    /* CD-ROM drive not in pause mode */
#endif

#ifndef MAX_TRACK_NO
    #define MAX_TRACK_NO       100     /* Max. no. of tracks on a disc */
#endif


#ifdef __cplusplus
}
#endif


#endif      /* #ifndef _SBKCD_H */
