/*===========================================================================*\
 | SBKMACRO.H (revision 1.0)                                                 |
 |       Macro definition for Microsoft C version and Turbo C version.       |
 |                                                                           |
 |---------------------------------------------------------------------------|
 | Copyright (c) Creative Technology Ltd, 1991-1993.                         |
 | All Rights Reserved.                                                      |
\*===========================================================================*/

#include <dos.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <errno.h>
#include <fcntl.h>
#include <bios.h>


#ifndef KEYBRD_READ
    #define KEYBRD_READ             0x0000
    #define KEYBRD_READY            0x0001
    #define KEYBRD_SHIFTSTATUS      0x0002
#endif


#if defined _MSC_VER

    #include <malloc.h>

    #define sbkAllocMem(numBytes)  ( (char far *) \
                halloc( (long)numBytes, (size_t)1 ) )

    #define sbkFreeMem(memblock)  ( (void) hfree( (char far *)memblock ) )

    #define sbkFindFirst(filename,fileinfo)  \
             ( (unsigned int) _dos_findfirst( (char *)filename,  \
               (_A_NORMAL | _A_RDONLY),  \
               (struct find_t *)fileinfo ) )

    #define sbkFindNext(fileinfo)   \
             ( (unsigned int) _dos_findnext( (struct find_t *) fileinfo ) )

    #define sbkBiosKeybrd(service)  \
            ( (unsigned int) _bios_keybrd( (unsigned int) service ) )


#elif defined(__TURBOC__) || defined(__BORLANDC__)

    #include <alloc.h>
    #include <dir.h>



    #define sbkAllocMem(numBytes)  ( (char far *) \
                farmalloc( (unsigned long) numBytes ) )

    #define sbkFreeMem(memblock)  ( (void) farfree( (char far *) memblock ) )

    #define sbkFindFirst(filename,fileinfo)  \
             ( (int) findfirst( (const char *)filename,  \
               (struct ffblk *)fileinfo, (int)0 ) )

    #define sbkFindNext(fileinfo)   \
             ( (int) findnext( (struct ffblk *) fileinfo ) )

    #define sbkBiosKeybrd(service)  \
            ( (unsigned int) bioskey( (int) service ) )

#endif
/* End of file */
