/*===========================================================================*\
 | SBKMIDI.H (revision 1.0)                                                  |
 |       API for CTMIDI.DRV                                                  |
 |                                                                           |
 |---------------------------------------------------------------------------|
 | Copyright (c) Creative Technology Ltd, 1991-1993.                         |
 | All Rights Reserved.                                                      |
\*===========================================================================*/

#ifndef _SBKMIDI_H
    #define _SBKMIDI_H

#include "ctstddef.h"

#ifdef __cplusplus
extern "C" {
#endif


typedef int (FAR PASCAL * MIDICALLBACK)(char FAR *,DWORD);


/* pointer to the entry point of the CTMIDI.DRV driver */

extern char far *CTmidiDrv;


/*---------------------------------------------------------------------------*\
 | Functions prototype.                                                      |
\*---------------------------------------------------------------------------*/

WORD CDECL ctmdGetDrvVer (void);                                  /* 0  */
WORD CDECL ctmdGetMidiEnvSettings (const char far *);             /* 1  */
WORD CDECL ctmdGetEnvSettings (const char far *);                 /* 2  */
WORD CDECL ctmdInit (void);                                       /* 3  */
WORD CDECL ctmdTerminate (void);                                  /* 4  */
WORD CDECL ctmdResetMidiDriver (void);                            /* 5  */
WORD CDECL ctmdSetChannelMapper (const char far *);               /* 6  */
WORD CDECL ctmdSetOutputStatusAddx (const WORD far *);            /* 7  */
WORD CDECL ctmdPrepareMidiStart (const unsigned char far *);      /* 8  */
WORD CDECL ctmdPlayMidiMusic (void);                              /* 9  */
WORD CDECL ctmdStopMidiMusic (void);                              /* 10 */
WORD CDECL ctmdPauseMidiMusic (void);                             /* 11 */
WORD CDECL ctmdResumeMidiMusic (void);                            /* 12 */
WORD CDECL ctmdGetMapperType (void);                              /* 13 */
WORD CDECL ctmdSetMapperType (WORD);                              /* 14 */
WORD CDECL ctmdSetMusicTempo (int);                               /* 15 */
WORD CDECL ctmdSetMusicTranspose (int);                           /* 16 */
WORD CDECL ctmdSendShortMessage (WORD, WORD, WORD);               /* 17 */
WORD CDECL ctmdSendLongMessage (char far *, WORD);                /* 18 */

WORD CDECL ctmdSetInputStatusAddx (WORD far *);                   /* 30 */
WORD CDECL ctmdSetTimeStampMode (WORD);                           /* 31 */
WORD CDECL ctmdSetMidiInputBuffer (DWORD far *, DWORD);           /* 32 */
WORD CDECL ctmdSetMidiCallBackFunct (MIDICALLBACK, DWORD);        /* 33 */
WORD CDECL ctmdStartMidiInput (void);                             /* 34 */
WORD CDECL ctmdStopMidiInput (void);                              /* 35 */

/* ------------------------- manifest constant -------------------------- */
/* Time stamp mode */
#define DIFFERENTIATE_MODE   0
#define ELAPSED_MODE         1

/* Output and input status */
#define MUSIC_IDLE           0
#define MUSIC_ACTIVE         1
#define MUSIC_PAUSED         2

#define MIDIREC_IDLE         0
#define MIDIREC_ACTIVE       1

/* Mapper type */
#define GENERAL_MIDI_MAPPER  0
#define EXTENDED_MIDI_MAPPER 1
#define BASIC_MIDI_MAPPER    2
#define USER_DEFINED_MAPPER  3

/* Synthesizer type */
#define INTERN_SYNTH         1
#define EXTERN_SYNTH         2


#ifdef __cplusplus
}
#endif

#endif  /* #ifndef _SBKMIDI_H */
