/*===========================================================================*\
 | SBKTS.H (revision 1.0)                                                    |
 |       API for CTTS.DRV, the DOS text to speech driver                     |
 |                                                                           |
 |---------------------------------------------------------------------------|
 | Copyright (c) Creative Technology Ltd, 1991-1993.                         |
 | All Rights Reserved.                                                      |
\*===========================================================================*/

#ifndef _SBKTS_H
    #define _SBKTS_H

#include "ctstddef.h"

#ifdef __cplusplus
extern "C" {
#endif


/*---------------------------------------------------------------------------*\
 | Set the pointer to the very first byte of the loaded driver.              |
\*---------------------------------------------------------------------------*/
extern void FAR *CTTSDrv;



/*---------------------------------------------------------------------------*\
 | Error message constants.                                                  |
\*---------------------------------------------------------------------------*/
#define EMPTY_BLASTER        0x0001
#define INVALID_BLASTER      0x0002
#define EMPTY_TEXT           0x0001
#define TEXT_TOO_LONG        0x0002


/*---------------------------------------------------------------------------*\
 | Function prototypes.                                                      |
\*---------------------------------------------------------------------------*/
WORD    CDECL   cttsGetDrvVer (void) ;
WORD    CDECL   cttsGetEnvSettings (const char FAR * lpszBlaster) ;
WORD    CDECL   cttsInit (void) ;
WORD    CDECL   cttsSay (const char FAR * lpszEnglishString) ;
void    CDECL   cttsSetSpeechParam (WORD wGender, WORD wTone, WORD wVolume,
                                    WORD wPitch, WORD wSpeed) ;
void    CDECL   cttsTerminate (void) ;


#ifdef __cplusplus
}
#endif


#endif      /* #ifndef _SBKTS_H */
