/*===========================================================================*\
 | SBKWAVE.H (revision 1.0)                                                  |
 |      API for CTWMEM.DRV and CTWSDK.DRV                                    |
 |                                                                           |
 |---------------------------------------------------------------------------|
 |             Copyright (c) Creative Technology Ltd, 1992-1993.             |
 |                           All Rights Reserved.                            |
\*===========================================================================*/

#ifndef _SBKWAVE_H
    #define _SBKWAVE_H


#include "ctstddef.h"


#ifdef __cplusplus
extern "C" {
#endif



/* Many functions return 0 if nothing went wrong.
 */
#ifndef NO_ERROR
     #define NO_ERROR   0
#endif



/*---------------------------------------------------------------------------*\
 | Set this pointer to the very first byte of the loaded driver.             |
\*---------------------------------------------------------------------------*/
extern LPVOID   CTwmemDrv;      /* For CTWMEM.DRV */
extern LPVOID   CTwdskDrv;      /* For CTWDSK.DRV */



/*---------------------------------------------------------------------------*\
 | Manifest constants for the {wParamType} argument of                       |
 |          ctwmGetParam()                                                   |
 |      and ctwdGetParam()                                                   |
\*---------------------------------------------------------------------------*/
#define CTWAV_DRIVERVERSION     0x0001
#define CTWAV_CARDTYPE          0x0002
#define CTWAV_LPCARDNAME        0x0003
#define CTWAV_INPUTCHANNELS     0x0004
#define CTWAV_OUTPUTCHANNELS    0x0005
#define CTWAV_IOHANDLES         0x0007
#define CTWAV_DRIVERBUILD       0x0008
#define CTWAV_SAMPLINGRANGE     0x000A
#define CTWAV_INPUTHANDLES      0x000B
#define CTWAV_OUTPUTHANDLES     0x000C
#define CTWAV_NEEDDMABUFFER     0x000D




/*---------------------------------------------------------------------------*\
 | Manifest constants for the {wParamType} argument of                       |
 |          ctwmSetIOParam(), ctwmGetIOParam()                               |
 |      and ctwdSetIOParam(), ctwdGetIOParam()                               |
\*---------------------------------------------------------------------------*/
#define CTWAV_IO_LPSTATUSWORD       0x0001
#define CTWAV_IN_SAMPLESPERSEC      0x0003
#define CTWAV_IN_NCHANNELS          0x0004
#define CTWAV_IN_LEFTINPUTS         0x0005
#define CTWAV_IN_RIGHTINPUTS        0x0006
#define CTWAV_IN_FORMAT             0x0007
#define CTWAV_IN_BITSPERSAMPLE      0x0008
#define CTWAV_IN_FILTER             0x0009
#define CTWAV_OUT_FILTER            0x000A



    /*-----------------------------------------------------------------------*\
     | Manifest constants for the {dwParam} argument of                      |
     |          ctwmSetIOParam(), ctwmGetIOParam()                           |
     |      and ctwdSetIOParam(), ctwdGetIOParam()                           |
     | when {wParamType == CTWAV_IN_WAVFMT}                                  |
    \*-----------------------------------------------------------------------*/
    #define WAVE_FORMAT_PCM             0x0001
    #define WAVE_FORMAT_ALAW            0x0006
    #define WAVE_FORMAT_MULAW           0x0007
    #define WAVE_FORMAT_CREATIVE_ADPCM  0x0200



    /*-----------------------------------------------------------------------*\
     | Manifest constants for the {dwParam} argument of                      |
     |          ctwmSetIOParam(), ctwmGetIOParam()                           |
     |      and ctwdSetIOParam(), ctwdGetIOParam()                           |
     | when {wParamType == CTWAV_IN_LEFTINPUTS or CTWAV_IN_RIGHTINPUTS}      |
    \*-----------------------------------------------------------------------*/
    #ifndef MIXERSWI_MIC
        #define MIXERSWI_MIC            0x0003
        #define MIXERSWI_CD_R           0x0004
        #define MIXERSWI_CD_L           0x0008
        #define MIXERSWI_LINE_R         0x0010
        #define MIXERSWI_LINE_L         0x0020
        #define MIXERSWI_MIDI_R         0x0040
        #define MIXERSWI_MIDI_L         0x0080
    #endif



    /*-----------------------------------------------------------------------*\
     | Manifest constants for the {dwParam} argument of                      |
     |          ctwmSetIOParam(), ctwmGetIOParam()                           |
     |      and ctwdSetIOParam(), ctwdGetIOParam()                           |
     | when {wParamType == CTWAV_IN_FILTER or CTWAV_OUT_FILTER}              |
    \*-----------------------------------------------------------------------*/
    #ifndef FILTER_OFF
        #define FILTER_OFF              0

        #define FILTER_LOW              0x0000FFFF
        #define FILTER_HIGH             0xFFFF0000

        #define FILTER_ON               0xFFFFFFFF
    #endif





/*---------------------------------------------------------------------------*\
 | Function prototypes for Memory .WAV Driver (CTWMEM.DRV) routines.         |
\*---------------------------------------------------------------------------*/
WORD    CDECL   ctwmContinue(
                    WORD    wIOHandle
                    );
WORD    CDECL   ctwmGetDrvError(
                    void
                    );
WORD    CDECL   ctwmGetEnvSettings(
                    LPCSTR  lpszBlaster
                    );
WORD    CDECL   ctwmGetIOParam(
                    WORD    wIOHandle,
                    WORD    wParamType,
                    LPDWORD lpdwParam
                    );
WORD    CDECL   ctwmGetParam(
                    WORD    wParamType,
                    LPDWORD lpdwParam
                    );
WORD    CDECL   ctwmInit(
                    void
                    );
WORD    CDECL   ctwmInputCM(
                    WORD    wIOHandle,
                    LPBYTE  lpBuf,
                    DWORD   dwBufLen
                    );
WORD    CDECL   ctwmInputXM(
                    WORD    wIOHandle,
                    WORD    wXMBHandle,
                    DWORD   dwXMBOffset,
                    WORD    wKBBufferSize
                    );
WORD    CDECL   ctwmOutputCM(
                    WORD    wIOHandle,
                    LPBYTE  lpBuf
                    );
WORD    CDECL   ctwmOutputXM(
                    WORD    wIOHandle,
                    WORD    wXMBHandle,
                    DWORD   dwXMBOffset
                    );
WORD    CDECL   ctwmPause(
                    WORD    wIOHandle
                    );
WORD    CDECL   ctwmSetDMABuffer(
                    WORD    wIOHandle,
                    DWORD   dw32BitAddx,
                    WORD    w2KBHalfBufferSize
                    );
WORD    CDECL   ctwmSetIOParam(
                    WORD    wIOHandle,
                    WORD    wParamType,
                    DWORD   dwParam
                    );
void    CDECL   ctwmSetSpeaker(
                    WORD    wfOnOff
                    );
WORD    CDECL   ctwmStop(
                    WORD    wIOHandle
                    );
void    CDECL   ctwmTerminate(
                    void
                    );




/*---------------------------------------------------------------------------*\
 | Function prototypes for Disk .WAV Driver (CTWDSK.DRV) routines.           |
\*---------------------------------------------------------------------------*/
WORD    CDECL   ctwdContinue(
                    WORD    wIOHandle
                    );
WORD    CDECL   ctwdGetDrvError(
                    void
                    );
WORD    CDECL   ctwdGetEnvSettings(
                    LPCSTR  lpszBlaster
                    );
WORD    CDECL   ctwdGetExtError(
                    void
                    );
WORD    CDECL   ctwdGetIOParam(
                    WORD    wIOHandle,
                    WORD    wParamType,
                    LPDWORD lpdwParam
                    );
WORD    CDECL   ctwdGetParam(
                    WORD    wParamType,
                    LPDWORD lpdwParam
                    );
WORD    CDECL   ctwdInit(
                    void
                    );
WORD    CDECL   ctwdInput(
                    WORD    wIOHandle,
                    WORD    wFileHandle
                    );
WORD    CDECL   ctwdOutput(
                    WORD    wIOHandle,
                    WORD    wFileHandle
                    );
WORD    CDECL   ctwdPause(
                    WORD    wIOHandle
                    );
WORD    CDECL   ctwdSetDiskBuffer(
                    WORD    wIOHandle,
                    LPBYTE  lpBuffer,
                    WORD    w2KBHalfBufferSize
                    );
WORD    CDECL   ctwdSetDMABuffer(
                    WORD    wIOHandle,
                    DWORD   dw32BitAddx,
                    WORD    w2KBHalfBufferSize
                    );
WORD    CDECL   ctwdSetIOParam(
                    WORD    wIOHandle,
                    WORD    wParamType,
                    DWORD   dwParam
                    );
void    CDECL   ctwdSetSpeaker(
                    WORD    wfOnOff
                    );
WORD    CDECL   ctwdStop(
                    WORD    wIOHandle
                    );
void    CDECL   ctwdTerminate(
                    void
                    );


#ifdef __cplusplus
}
#endif


#endif      /* #ifndef _SBKWAVE_H */
